# -*- coding: utf-8 -*-
"""r04.ipynb

Automatically generated by Colaboratory.

Original file is located at
    https://colab.research.google.com/drive/1luPwi0LyWGpBfAjk_qWbbECS1KmO1fKD

# Rozdział 4.
"""

# importowanie bibliotek
import numpy as np
import matplotlib.pyplot as plt


# UWAGA: poniżej zdefiniowano globalne ustawienia związane z wyglądem rysunków,
# które wykorzystano do wygenerowania rysunków pokazanych w książce

from IPython import display
display.set_matplotlib_formats('svg') # Rysunki w formacie wektorowym
plt.rcParams.update({'font.size':14}) # Rozmiar czcionki

N = 30

x = np.linspace(0,10,N) + np.random.randn(N)
y = x + np.random.randn(N)


_,axs = plt.subplots(2,2,figsize=(6,6))

axs[0,0].plot(x,y,'ko')
axs[0,0].set_title('Dodatnia korelacja',fontweight='bold')
axs[0,0].set_xlabel('Zmienna x')
axs[0,0].set_ylabel('Zmienna y')
axs[0,0].set_xticks([])
axs[0,0].set_yticks([])
axs[0,0].axis('square')


# negative correlation
axs[0,1].plot(x,-y,'ko')
axs[0,1].set_title('Ujemna korelacja',fontweight='bold')
axs[0,1].set_xlabel('Zmienna x')
axs[0,1].set_ylabel('Zmienna y')
axs[0,1].set_xticks([])
axs[0,1].set_yticks([])
axs[0,1].axis('square')


# zero correlation, part 1
axs[1,0].plot(np.random.randn(N),np.random.randn(N),'ko')
axs[1,0].set_title('Brak korelacji',fontweight='bold')
axs[1,0].set_xlabel('Zmienna x')
axs[1,0].set_ylabel('Zmienna y')
axs[1,0].set_xticks([])
axs[1,0].set_yticks([])
axs[1,0].axis('square')


# zero correlation, part 2
x = np.cos(np.linspace(0,2*np.pi,N)) + np.random.randn(N)/20
y = np.sin(np.linspace(0,2*np.pi,N)) + np.random.randn(N)/20
axs[1,1].plot(x,y,'ko')
axs[1,1].set_title('Brak korelacji',fontweight='bold')
axs[1,1].set_xlabel('Zmienna x')
axs[1,1].set_ylabel('Zmienna y')
axs[1,1].set_xticks([])
axs[1,1].set_yticks([])
axs[1,1].axis('square')


plt.tight_layout()
plt.savefig('rys4.1.png',dpi=300)
plt.show()



### Uwaga: Kod algorytmu k-means znajdziesz w ćwiczeniu 8.



"""# Ćwiczenie 1."""

# funkcja
def corrAndCosine(x,y):

  # podobieństwo cosinusowe
  num = np.dot(x,y) # licznik
  den = np.linalg.norm(x) * np.linalg.norm(y) # mianownik
  cos = num / den

  # współczynnik korelacji Pearsona (kod podobny do powyższego, ale dane dodatkowo wyśrodkowujemy!)
  xm  = x-np.mean(x)
  ym  = y-np.mean(y)
  num = np.dot(xm,ym) # licznik
  den = np.linalg.norm(xm) * np.linalg.norm(ym) # mianownik
  cor = num / den

  return cor,cos


# test
a = np.random.randn(15)
b = np.random.randn(15)

# obliczam wskaźniki
r,c = corrAndCosine(a,b)

# sprawdzam, czy wyniki pokrywają się z tymi z np.corrcoef
print(r,np.corrcoef(a,b)[0,1])

# sprawdzam wartości współczynników dla niewyśrodkowanych danych
a = np.random.randn(15) + 10 # uwaga na offset!
b = np.random.randn(15)

# wyśrodkowanie
aNoMean = a - np.mean(a)
bNoMean = b - np.mean(b)


# wyświetlam wyniki
print('Bez wyśrodkowania (wartości powinny się różnić):')
print( np.round(corrAndCosine(a,b),4) )
print(' ')

print('Dane wyśrodkowane (obie wartości powinny być takie same):')
print( np.round(corrAndCosine(aNoMean,bNoMean),4) )

# Uwaga: Wyniki pokazano powyżej zostały zaokrąglone do czterech miejsc po przecinku

"""## Ćwiczenie 2."""

# tworzę zmienne
a = np.arange(4,dtype=float)
offsets = np.arange(-50,51)

# inicjalizacja zmiennej results
results = np.zeros((len(offsets),2))

# uruchamiam symulację!
for i in range(len(offsets)):
    results[i,:] = corrAndCosine(a,a+offsets[i])


# wykreślam wynik!
plt.figure(figsize=(8,4))
h = plt.plot(offsets,results)
h[0].set_color('k')
h[0].set_marker('o')
h[1].set_color([.7,.7,.7])
h[1].set_marker('s')

plt.xlabel('Przesunięcie')
plt.ylabel('Wartość wskaźnika')
plt.legend(['Korelacja\nPearsona','Podobieństwo\ncosinusowe'])
plt.savefig('rys4.4.png',dpi=300, bbox_inches='tight')
plt.show()



"""## Ćwiczenie 3."""

# import pakietu
from scipy.stats import pearsonr

# sprawdzenie kodu źródłowego
??pearsonr



"""## Ćwiczenie 4."""

# funkcja obliczająca współczynnik korelacji Pearsona
def rho(x,y):
  xm = x-np.mean(x)
  ym = y-np.mean(y)
  n  = np.dot(xm,ym)
  d  = np.linalg.norm(xm) * np.linalg.norm(ym)
  return n/d


# import biblioteki time
import time

# parametry eksperymentu
numIters  = 1000
varLength =  500

# pomiar czasu działania mojej implementacji
tic = time.time()
for i in range(numIters):
  x = np.random.randn(varLength,2)
  rho(x[:,0],x[:,1])
t1 = time.time() - tic


# pomiar czasu działania funkcji corrcoef z NumPy
tic = time.time()
for i in range(numIters):
  x = np.random.randn(varLength,2)
  pearsonr(x[:,0],x[:,1])
t2 = time.time() - tic


# wyświetlanie wyników!
# Uwaga: funkcja time() zwraca czas w sekundach. Pomnożyłem go przez 1000, aby otrzymać wyniki w milisekundach
print(f'Moja implementacja: {t1*1000:.2f} ms')
print(f'  Funkcja pearsonr: {t2*1000:.2f} ms')



"""# Exercise 5"""

# tworzenie jądra
kernel = np.array([-1,1])

# i „sygnału” (funkcja plateau)
signal = np.zeros(30)
signal[10:20] = 1


# wykreślanie wyniku
_,axs = plt.subplots(1,2,figsize=(12,4))
axs[0].plot(kernel,'ks-')
axs[0].set_title('Jądro')
axs[0].set_xlim([-15,15])

axs[1].plot(signal,'ks-')
axs[1].set_title('Sygnal')

plt.savefig('rys4.5.png',dpi=300)
plt.show()

# inicjalizacja zmiennej featureMap
featureMap = np.zeros(len(signal))

# pętla po sygnale i stosowanie na nim jądra (za pomocą iloczynu skalarnego!)
for t in range(1,len(signal)-1):
  featureMap[t] = np.dot(kernel,signal[t-1:t+1])


# wykreślanie wyników
_,axs = plt.subplots(1,2,figsize=(12,4))
axs[0].plot(kernel,'ks-')
axs[0].set_title('Jądro')
axs[0].set_xlim([-15,15])


axs[1].plot(signal,'ks-',label='Sygnał',linewidth=3)
markers,stemlines,_ = axs[1].stem(range(len(featureMap)),featureMap,
                                  basefmt=' ',linefmt='',markerfmt='o',
                                  label='Detektor krawędzi')

plt.setp(stemlines,'color',[.7,.7,.7])
plt.setp(markers,'color',[.7,.7,.7])

axs[1].legend()
plt.savefig('rys4.5c.png',dpi=300)
plt.show()



"""# Ćwiczenie 6."""

# definicja jądra
kernel = np.array([0,.1,.3,.8,1,.8,.3,.1,0])
kernel = kernel / np.sum(kernel)

# parametry
Nkernel = len(kernel)
halfKrn = Nkernel//2


# sygnał
Nsignal = 100
timeseries = np.random.randn(Nsignal)


# tworzenie wykresu
_,axs = plt.subplots(1,2,figsize=(12,4))
axs[0].plot(kernel,'ks-')
axs[0].set_title('Jądro')
axs[0].set_xlim([-1,Nsignal])

axs[1].plot(timeseries,'ks-')
axs[1].set_title('Szereg czasowy (sygnał)')

plt.savefig('rys4.6ab.png',dpi=300)
plt.show()

# tworzę kopię sygnału
filtsig = timeseries.copy()

# pętla po punktach sygnału
for t in range(halfKrn+1,Nsignal-halfKrn):
  filtsig[t] = np.dot(kernel,timeseries[t-halfKrn-1:t+halfKrn])


# tworzenie wykresu
_,axs = plt.subplots(1,2,figsize=(12,4))
axs[0].plot(kernel,'ks-')
axs[0].set_title('Jądro')
axs[0].set_xlim([-1,Nsignal])

axs[1].plot(timeseries,color='k',label='Oryginalny sygnał',linewidth=1)
axs[1].plot(filtsig,'--',color=[.6,.6,.6],label='Wygładzony sygnał',linewidth=2)
axs[1].legend()

plt.savefig('rys4.6c.png',dpi=300)
plt.show()

"""# Ćwiczenie 7."""

# definicja jądra
kernel = np.array([0,.1,.3,.8,-1,.8,.3,.1,0])
kernel /= np.sum(kernel)
kernel -= np.mean(kernel)

# tworzenie wykresu
_,axs = plt.subplots(1,2,figsize=(12,4))
axs[0].plot(kernel,'s-')
axs[0].set_title('Jądro')
axs[0].set_xlim([-1,Nsignal])

axs[1].plot(timeseries,'s-')
axs[1].set_title('Szereg czasowy (sygnał)')
plt.show()



# pętla po punktach sygnału
filtsig2 = timeseries.copy()
for t in range(halfKrn+1,Nsignal-halfKrn):
  filtsig2[t] = np.dot(kernel,timeseries[t-halfKrn-1:t+halfKrn])

plt.plot(timeseries,color='k',label='Oryginalny sygnał',linewidth=1)
plt.plot(filtsig2,color=[.9,.2,.7],label='Wyostrzony sygnał',linewidth=1)
plt.legend()
plt.show()



"""# Ćwiczenie 8."""

# tworzenie danych
nPerClust = 50

# wartość skalująca losowe dane
blur = 1

# współrzędne centroidów
A = [  1, 1 ]
B = [ -3, 1 ]
C = [  3, 3 ]

# generowanie danych
a = [ A[0]+np.random.randn(nPerClust)*blur , A[1]+np.random.randn(nPerClust)*blur ]
b = [ B[0]+np.random.randn(nPerClust)*blur , B[1]+np.random.randn(nPerClust)*blur ]
c = [ C[0]+np.random.randn(nPerClust)*blur , C[1]+np.random.randn(nPerClust)*blur ]

# połączenie danych w macierz
data = np.transpose( np.concatenate((a,b,c),axis=1) )


# tworzenie wykresu
plt.plot(data[:,0],data[:,1],'ko',markerfacecolor='w')
plt.title('Surowe dane (przed klasteryzacją)')
plt.xticks([])
plt.yticks([])

plt.show()

# Inicjalizacja centroidów
k = 3

ridx = np.random.choice(range(len(data)),k,replace=False)
centroids = data[ridx,:] # wiersze macierzy data to obserwacje; kolumny to cechy


fig,axs = plt.subplots(2,2,figsize=(6,6))
axs = axs.flatten()
lineColors = [ [0,0,0],[.4,.4,.4],[.8,.8,.8] ]


# wykreślanie danych z losowymi centroidami
axs[0].plot(data[:,0],data[:,1],'ko',markerfacecolor='w')
axs[0].plot(centroids[:,0],centroids[:,1],'ko')
axs[0].set_title('Iteracja 0')
axs[0].set_xticks([])
axs[0].set_yticks([])



# pętla po iteracjach
for iteri in range(3):

  # krok 1.: obliczanie odległości
  dists = np.zeros((data.shape[0],k))
  for ci in range(k):
    dists[:,ci] = np.sum((data-centroids[ci,:])**2,axis=1)

  # krok 2.: przypisywanie do najbliżej położonych klastrów
  groupidx = np.argmin(dists,axis=1)

  # krok 3.: ponowne wyznaczanie centroidów
  for ki in range(k):
    centroids[ki,:] = [ np.mean(data[groupidx==ki,0]), np.mean(data[groupidx==ki,1]) ]


  # wykreślanie danych
  for i in range(len(data)):
    axs[iteri+1].plot([ data[i,0],centroids[groupidx[i],0] ],[ data[i,1],centroids[groupidx[i],1] ],color=lineColors[groupidx[i]])
  axs[iteri+1].plot(centroids[:,0],centroids[:,1],'ko')
  axs[iteri+1].set_title(f'Iteracja {iteri+1}')
  axs[iteri+1].set_xticks([])
  axs[iteri+1].set_yticks([])


plt.savefig('rys4.3.png',dpi=300)
plt.show()

